import requests
from bs4 import BeautifulSoup

def check_url(url):
    try:
        r = requests.get(url, timeout=5)
        status = r.status_code
        soup = BeautifulSoup(r.text, 'html.parser')
        links = soup.find_all('a')
        anchor = links[0].text if links else ''
        follow = 'nofollow' not in [l.get('rel','') for l in links]
        return {'url': url, 'status': status, 'follow': follow, 'anchor': anchor}
    except Exception as e:
        return {'url': url, 'status': 'Error', 'follow': '', 'anchor': ''}
